# This file contains data for appraisal prediction for emotion analysis.

For questions, please contact Roman Klinger
(roman.klinger@ims.uni-stuttgart.de).

This zip file contains the following folders with files:

## ```full-corpus-three-annotators/```
The data file ```emotion_appraisal_corpus.tsv``` data is described in the paper:

* Jan Hofmann, Enrica Troiano, Kai Sassenberg, and Roman Klinger. Appraisal theories for emotion classification in text. In Proceedings of the 28th International Conference on Computational Linguistics, 2020.

If you want to build appraisal classifiers, this is the data to use,
as it is annotated by multiple people, and the file provides the
numbers of annotators for each dimension.


## ```annotation-experiments/```

This folder contains two folders, with automatic and manual annotation experiment data:

* ```Manual/``` contains the data for manual annotations (with and without visibility of the emotion label)
  * enISEAR_appraisal_hidden_A.tsv
    contains annotations performed by annotator A on all instances in enISEAR 'without access' to the emotion label.
    * enISEAR_appraisal_visible_A.tsv
      contains annotations performed by annotator A on all instances in enISEAR 'with access' to the emotion label.
    * subset_enISEAR_appraisal_hidden_[X].tsv
      contains annotations performed by annotator A/B on a randomly chosen subset of enISEAR stratisfied by emotion labels. The annotations were performed 'without giving access' to the emotion label.
    * subset_enISEAR_appraisal_visible_[X].tsv
      contains annotations performed by annotator A/B on a randomly chosen subset of enISEAR stratisfied by emotion labels. The annotations were performed 'with access' to the emotion label.
  * ```automatic/``` contains the data for automatically projecting labels from the existing emotion class to appraisal dimensions (only for the data that we originally created).
      * enISEAR_appraisal_automated.tsv
    * deISEAR_appraisal_automated.tsv

## ```papers/```
* ```papers/HofmannCOLING2020.pdf``` describes the data as it is available
in full-corpus-three-annotators/.
* ```papers/TroianoACL2019.pdf``` describes the original data collection of
the two corpora that have been postannotated for the appraisal
studies.
* ```papers/HofmannWASSA2021.pdf``` describes experiments on the annotation
with and without visibility of emotions (as available in
annotation-experiments/).



## Bib-TeX entries

If you use our data, please consider citing the (a subset of the) three papers that we published so far on the topic of emotion and appraisal prediction in event-focused text.

Original data:

```
@inproceedings{troiano-etal-2019-crowdsourcing,
    title = "Crowdsourcing and Validating Event-focused Emotion Corpora for {G}erman and {E}nglish",
    author = "Troiano, Enrica  and
      Pad{\'o}, Sebastian  and
      Klinger, Roman",
    booktitle = "Proceedings of the 57th Annual Meeting of the Association for Computational Linguistics",
    month = jul,
    year = "2019",
    address = "Florence, Italy",
    publisher = "Association for Computational Linguistics",
    url = "https://www.aclweb.org/anthology/P19-1391",
    doi = "10.18653/v1/P19-1391",
    pages = "4005--4011",
}
```

Full annotation with appraisal dimensions:

```
@inproceedings{hofmann-etal-2020-appraisal,
    title = "Appraisal Theories for Emotion Classification in Text",
    author = "Hofmann, Jan  and
      Troiano, Enrica  and
      Sassenberg, Kai  and
      Klinger, Roman",
    booktitle = "Proceedings of the 28th International Conference on Computational Linguistics",
    month = dec,
    year = "2020",
    address = "Barcelona, Spain (Online)",
    publisher = "International Committee on Computational Linguistics",
    url = "https://www.aclweb.org/anthology/2020.coling-main.11",
    doi = "10.18653/v1/2020.coling-main.11",
    pages = "125--138",
}
```

Annotation experiment with visible and hidden emotion labels:

```
@inproceedings{Hofmann2021,
  author = {Jan Hofmann and Enrica Troiano and Roman Klinger},
  title = {Emotion-Aware, Emotion-Agnostic, or Automatic: A Study of Manual Annotation Strategies for Cognitive Event Appraisal and the Influence on Model Performance},
  booktitle = {Proceedings of the 11th Workshop on Computational
                  Approaches to Subjectivity, Sentiment and Social
                  Media Analysis},
  year = {2021},
}
```



--------------------------------------------------------------------------------
